#pragma rtGlobals=1		// Use modern global access method.
#include <axis utilities>

function bb()	// background blue
	// makes a graph more slide-like
	ModifyGraph fSize=14, rgb=(65535,65535,65535), gbRGB=(0,10161,40630)
	ModifyGraph axRGB=(65535,65535,65535), tlblRGB=(65535,65535,65535)
	ModifyGraph alblRGB=(65535,65535,65535), wbRGB=(0,10161,40630)
	modifygraph msize=0, mrkThick=1.5, opaque=0
end

function fp()	// for poster using Igor layout (11x17, 400% magnification for final print)
	string myaxislist=axislist(""), tempstr
	variable i, tempval
	modifygraph fsize=4, btLen = 2, stLen = 1, msize=1, lsize=.5
	for (i= 0; i < itemsinlist (myaxislist); i += 1)	// go through axes and fix axis thickness if non-zero
		tempstr = axisinfo ("", stringfromlist (i, myaxislist))
		tempval = strsearch (tempstr, "axThick(x)=", 0)
		if (str2num (tempstr[tempval + 11, tempval + 15]) != 0)
			modifygraph axThick($(stringfromlist (i, myaxislist)))=.25
		endif
	endfor
end

function ffh() // for FreeHand for making poster (200% magnification for final print)
	string mylist=axislist(""), tempstr
	variable i, tempval
	modifygraph fsize=9, btLen = 2, stLen = 1, msize=2, lsize=1, opaque=0, expand=4
	for (i= 0; i < itemsinlist (mylist); i += 1)	// go through axes and fix axis thickness if non-zero
		tempstr = axisinfo ("", stringfromlist (i, mylist))
		tempval = strsearch (tempstr, "axThick(x)=", 0)
		if (str2num (tempstr[tempval + 11, tempval + 15]) != 0)
			modifygraph axThick($(stringfromlist (i, mylist)))=1
		endif
		tempstr = axislabeltext ("", stringfromlist (i, mylist), suppressescaping=1)
		label $(stringfromlist (i, mylist)) stripescapes (tempstr)
	endfor
	mylist = annotationlist ("")
	for (i = 0; i < itemsinlist (mylist); i += 1)
		tempstr = annotationinfo ("", stringfromlist (i, mylist))
		tempval = strsearch (tempstr, "TEXT:", 0)
		tempstr = stripescapes (replacestring ("\\\\", tempstr[tempval + 5, inf], "\\"))
		textbox /c/n=$(stringfromlist (i, mylist)) tempstr
	endfor
end

function /t checkthisesc (mystr, flag, del)
	string mystr, flag
	variable del
	variable escpos, endpos
	
	do
		escpos = strsearch (mystr, flag, 0)
		if (escpos != -1)
			if (cmpstr (flag, "\'") == 0)
				endpos = strsearch (mystr, "'", escpos + 1)
				del = endpos - escpos + 1
			endif
			mystr = mystr[0,escpos - 1] + mystr [escpos + del, inf]
		endif
	while (escpos != -1)
	return mystr
end
function /t stripEscapes (mystr)
	string mystr
	mystr = checkthisesc (mystr, "\'", 0)
	mystr = checkthisesc (mystr, "\Z", 4)
	mystr = checkthisesc (mystr, "\f", 4)
	mystr = checkthisesc (mystr, "\[", 3)
	mystr = checkthisesc (mystr, "\]", 3)
	mystr = checkthisesc (mystr, "\M", 2)
	mystr = checkthisesc (mystr, "\S", 2)
	mystr = checkthisesc (mystr, "\B", 2)
	return mystr
end

function fw() // for Word
	// makes a graph good to export to Word at 4X
	modifygraph fsize=32, lsize=2, msize=8
end

function bg()	// blackgraph
	modifygraph rgb=(0,0,0)
end


function tl()	// thin line
	ModifyGraph lsize=0.5
end

function hl()	// hide labels
	ModifyGraph noLabel=2,axThick=0, margin=-1
end

function ha(a) // hide axis
	string a
	ModifyGraph noLabel($a)=2,axThick($a)=0
end

function hbl()	// hide bottom labels
	ModifyGraph noLabel(bottom)=2,axThick(bottom)=0, margin(bottom)=-1
end

function cca()	// current clamp axes
	hbl()
	modifygraph margin(top)=-1, margin(right)=-1,margin(left)=29
	label left "\f02V\f00\Bm\M (\U)"
	ModifyGraph manTick(left)={0,60,0,0},manMinor(left)={0,0}
	SetAxis/A/E=1 left
end

function ff()	// fix fonts, goes through whole graph, changing everything to Helvetica
	variable i
	string alltextboxes, textboxname, textboxinfo, oldtext
	ModifyGraph font="Helvetica"
//	showtools /a
//	SetDrawEnv fname= "Helvetica"
	alltextboxes = AnnotationList ("")
	i = 0
	do
		textboxname = StringFromList (i, alltextboxes)
		if (strlen (textboxname) != 0)		// i.e. didn't find another one
//			printf "."
			textboxinfo = annotationinfo ("", textboxname)
			oldtext = StringByKey("TEXT", textboxinfo)
			if (strsearch (oldtext, "\F'Helvetica'", 0) == -1)
				 if (cmpstr (stringbykey ("TYPE", textboxinfo), "Tag") == 0)
					Tag /C/N=$textboxname "\F'Helvetica'" + oldtext
				 endif
				 if (cmpstr (stringbykey ("TYPE", textboxinfo), "Textbox") == 0)
					Textbox /C/N=$textboxname "\F'Helvetica'" + oldtext
				 endif
				 if (cmpstr (stringbykey ("TYPE", textboxinfo), "Legend") == 0)
					Legend /C/N=$textboxname "\F'Helvetica'" + oldtext
				 endif
			endif
		endif
		i += 1
	while (strlen (textboxname) > 0)
//	print " "
end

function fat()	//fix axis ticks
	ModifyGraph standoff=0,btLen=4,stLen=2, font="Helvetica", fsize=8, msize=2
end

function ml()		// modify layout
	modifylayout trans=1, frame=0
endmacro
